using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace Filter {
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form {
        SqlConnection cn;
        SqlCommand cmd;
        SqlDataAdapter da;
        DataSet ds;
        int i;


        internal System.Windows.Forms.TabControl TabControl1;
        internal System.Windows.Forms.TabPage TabPage1;
        internal System.Windows.Forms.TextBox txtFilter;
        internal System.Windows.Forms.Button btnFilter;
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.TabPage TabPage2;
        internal System.Windows.Forms.TextBox txtGeneralFilter;
        internal System.Windows.Forms.Button btnGeneralFilter;
        internal System.Windows.Forms.Label Label3;
        internal System.Windows.Forms.TabPage TabPage3;
        internal System.Windows.Forms.RadioButton rbDsc;
        internal System.Windows.Forms.Button btnSort;
        internal System.Windows.Forms.RadioButton rbAsc;
        internal System.Windows.Forms.Label Label2;
        internal System.Windows.Forms.ComboBox cmbSortArg;
        internal System.Windows.Forms.TextBox txtQYearHigh;
        internal System.Windows.Forms.TextBox txtQYearLow;
        internal System.Windows.Forms.Button btnQuery;
        internal System.Windows.Forms.DataGrid DataGrid1;
        internal System.Windows.Forms.TextBox txtQTitle;
        internal System.Windows.Forms.TextBox txtShowRows;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1() {
            try {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //

                cn = new SqlConnection("server=.;database=biblio;uid=admin;pwd=pw");

                cmd = new SqlCommand("GetTitlesByYear", cn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.Add("@TitleWanted", SqlDbType.VarChar, 20);
                cmd.Parameters.Add("@YearLow", SqlDbType.Int);
                cmd.Parameters.Add("@YearHigh", SqlDbType.Int);

                da = new SqlDataAdapter(cmd);

                ds = new DataSet();

                RunQuery();
                txtFilter.Text = txtQTitle.Text;

            }
            catch (Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.TabControl1 = new System.Windows.Forms.TabControl();
            this.TabPage1 = new System.Windows.Forms.TabPage();
            this.txtFilter = new System.Windows.Forms.TextBox();
            this.btnFilter = new System.Windows.Forms.Button();
            this.Label1 = new System.Windows.Forms.Label();
            this.TabPage2 = new System.Windows.Forms.TabPage();
            this.txtGeneralFilter = new System.Windows.Forms.TextBox();
            this.btnGeneralFilter = new System.Windows.Forms.Button();
            this.Label3 = new System.Windows.Forms.Label();
            this.TabPage3 = new System.Windows.Forms.TabPage();
            this.rbDsc = new System.Windows.Forms.RadioButton();
            this.btnSort = new System.Windows.Forms.Button();
            this.rbAsc = new System.Windows.Forms.RadioButton();
            this.Label2 = new System.Windows.Forms.Label();
            this.cmbSortArg = new System.Windows.Forms.ComboBox();
            this.txtQYearHigh = new System.Windows.Forms.TextBox();
            this.txtQYearLow = new System.Windows.Forms.TextBox();
            this.btnQuery = new System.Windows.Forms.Button();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            this.txtQTitle = new System.Windows.Forms.TextBox();
            this.txtShowRows = new System.Windows.Forms.TextBox();
            this.TabControl1.SuspendLayout();
            this.TabPage1.SuspendLayout();
            this.TabPage2.SuspendLayout();
            this.TabPage3.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // TabControl1
            // 
            this.TabControl1.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                      this.TabPage1,
                                                                                      this.TabPage2,
                                                                                      this.TabPage3});
            this.TabControl1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.TabControl1.Location = new System.Drawing.Point(8, 96);
            this.TabControl1.Name = "TabControl1";
            this.TabControl1.SelectedIndex = 0;
            this.TabControl1.Size = new System.Drawing.Size(520, 120);
            this.TabControl1.TabIndex = 18;
            // 
            // TabPage1
            // 
            this.TabPage1.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                   this.txtFilter,
                                                                                   this.btnFilter,
                                                                                   this.Label1});
            this.TabPage1.Location = new System.Drawing.Point(4, 25);
            this.TabPage1.Name = "TabPage1";
            this.TabPage1.Size = new System.Drawing.Size(512, 91);
            this.TabPage1.TabIndex = 0;
            this.TabPage1.Text = "Filter on Title";
            // 
            // txtFilter
            // 
            this.txtFilter.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtFilter.Location = new System.Drawing.Point(120, 24);
            this.txtFilter.Name = "txtFilter";
            this.txtFilter.Size = new System.Drawing.Size(368, 22);
            this.txtFilter.TabIndex = 1;
            this.txtFilter.Text = "";
            // 
            // btnFilter
            // 
            this.btnFilter.Location = new System.Drawing.Point(192, 56);
            this.btnFilter.Name = "btnFilter";
            this.btnFilter.Size = new System.Drawing.Size(96, 24);
            this.btnFilter.TabIndex = 2;
            this.btnFilter.Text = "Filter Title";
            this.btnFilter.Click += new System.EventHandler(this.btnFilter_Click);
            // 
            // Label1
            // 
            this.Label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label1.Location = new System.Drawing.Point(16, 24);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(88, 24);
            this.Label1.TabIndex = 7;
            this.Label1.Text = "Title like...";
            this.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // TabPage2
            // 
            this.TabPage2.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                   this.txtGeneralFilter,
                                                                                   this.btnGeneralFilter,
                                                                                   this.Label3});
            this.TabPage2.Location = new System.Drawing.Point(4, 25);
            this.TabPage2.Name = "TabPage2";
            this.TabPage2.Size = new System.Drawing.Size(512, 91);
            this.TabPage2.TabIndex = 1;
            this.TabPage2.Text = "General Filter";
            this.TabPage2.Visible = false;
            // 
            // txtGeneralFilter
            // 
            this.txtGeneralFilter.Location = new System.Drawing.Point(112, 24);
            this.txtGeneralFilter.Name = "txtGeneralFilter";
            this.txtGeneralFilter.Size = new System.Drawing.Size(376, 22);
            this.txtGeneralFilter.TabIndex = 1;
            this.txtGeneralFilter.Text = "";
            // 
            // btnGeneralFilter
            // 
            this.btnGeneralFilter.Location = new System.Drawing.Point(192, 56);
            this.btnGeneralFilter.Name = "btnGeneralFilter";
            this.btnGeneralFilter.Size = new System.Drawing.Size(96, 24);
            this.btnGeneralFilter.TabIndex = 2;
            this.btnGeneralFilter.Text = "Filter";
            this.btnGeneralFilter.Click += new System.EventHandler(this.btnGeneralFilter_Click);
            // 
            // Label3
            // 
            this.Label3.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label3.Location = new System.Drawing.Point(16, 24);
            this.Label3.Name = "Label3";
            this.Label3.Size = new System.Drawing.Size(88, 24);
            this.Label3.TabIndex = 7;
            this.Label3.Text = "Filter criteria";
            this.Label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // TabPage3
            // 
            this.TabPage3.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                   this.rbDsc,
                                                                                   this.btnSort,
                                                                                   this.rbAsc,
                                                                                   this.Label2,
                                                                                   this.cmbSortArg});
            this.TabPage3.Location = new System.Drawing.Point(4, 25);
            this.TabPage3.Name = "TabPage3";
            this.TabPage3.Size = new System.Drawing.Size(512, 91);
            this.TabPage3.TabIndex = 2;
            this.TabPage3.Text = "Sort";
            this.TabPage3.Visible = false;
            // 
            // rbDsc
            // 
            this.rbDsc.Location = new System.Drawing.Point(400, 40);
            this.rbDsc.Name = "rbDsc";
            this.rbDsc.Size = new System.Drawing.Size(96, 16);
            this.rbDsc.TabIndex = 8;
            this.rbDsc.Text = "Descending";
            // 
            // btnSort
            // 
            this.btnSort.Location = new System.Drawing.Point(192, 56);
            this.btnSort.Name = "btnSort";
            this.btnSort.Size = new System.Drawing.Size(96, 24);
            this.btnSort.TabIndex = 2;
            this.btnSort.Text = "Sort";
            this.btnSort.Click += new System.EventHandler(this.btnSort_Click);
            // 
            // rbAsc
            // 
            this.rbAsc.Checked = true;
            this.rbAsc.Location = new System.Drawing.Point(400, 16);
            this.rbAsc.Name = "rbAsc";
            this.rbAsc.Size = new System.Drawing.Size(96, 16);
            this.rbAsc.TabIndex = 8;
            this.rbAsc.TabStop = true;
            this.rbAsc.Text = "Ascending";
            // 
            // Label2
            // 
            this.Label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label2.Location = new System.Drawing.Point(16, 24);
            this.Label2.Name = "Label2";
            this.Label2.Size = new System.Drawing.Size(88, 24);
            this.Label2.TabIndex = 7;
            this.Label2.Text = "Sort by...";
            this.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // cmbSortArg
            // 
            this.cmbSortArg.DropDownWidth = 176;
            this.cmbSortArg.Location = new System.Drawing.Point(112, 24);
            this.cmbSortArg.Name = "cmbSortArg";
            this.cmbSortArg.Size = new System.Drawing.Size(272, 24);
            this.cmbSortArg.TabIndex = 9;
            // 
            // txtQYearHigh
            // 
            this.txtQYearHigh.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtQYearHigh.Location = new System.Drawing.Point(328, 48);
            this.txtQYearHigh.Name = "txtQYearHigh";
            this.txtQYearHigh.Size = new System.Drawing.Size(104, 22);
            this.txtQYearHigh.TabIndex = 15;
            this.txtQYearHigh.Text = "1999";
            // 
            // txtQYearLow
            // 
            this.txtQYearLow.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtQYearLow.Location = new System.Drawing.Point(208, 48);
            this.txtQYearLow.Name = "txtQYearLow";
            this.txtQYearLow.Size = new System.Drawing.Size(104, 22);
            this.txtQYearLow.TabIndex = 16;
            this.txtQYearLow.Text = "1900";
            // 
            // btnQuery
            // 
            this.btnQuery.Location = new System.Drawing.Point(40, 32);
            this.btnQuery.Name = "btnQuery";
            this.btnQuery.Size = new System.Drawing.Size(96, 24);
            this.btnQuery.TabIndex = 13;
            this.btnQuery.Text = "Query";
            this.btnQuery.Click += new System.EventHandler(this.btnQuery_Click);
            // 
            // DataGrid1
            // 
            this.DataGrid1.DataMember = "";
            this.DataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.DataGrid1.Location = new System.Drawing.Point(0, 224);
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.Size = new System.Drawing.Size(536, 256);
            this.DataGrid1.TabIndex = 17;
            // 
            // txtQTitle
            // 
            this.txtQTitle.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtQTitle.Location = new System.Drawing.Point(208, 16);
            this.txtQTitle.Name = "txtQTitle";
            this.txtQTitle.Size = new System.Drawing.Size(296, 22);
            this.txtQTitle.TabIndex = 12;
            this.txtQTitle.Text = "Hitch%";
            // 
            // txtShowRows
            // 
            this.txtShowRows.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.txtShowRows.Location = new System.Drawing.Point(0, 485);
            this.txtShowRows.Multiline = true;
            this.txtShowRows.Name = "txtShowRows";
            this.txtShowRows.Size = new System.Drawing.Size(536, 176);
            this.txtShowRows.TabIndex = 14;
            this.txtShowRows.Text = "";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(536, 661);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.TabControl1,
                                                                          this.txtQYearHigh,
                                                                          this.txtQYearLow,
                                                                          this.btnQuery,
                                                                          this.DataGrid1,
                                                                          this.txtQTitle,
                                                                          this.txtShowRows});
            this.Name = "Form1";
            this.Text = "Filter";
            this.TabControl1.ResumeLayout(false);
            this.TabPage1.ResumeLayout(false);
            this.TabPage2.ResumeLayout(false);
            this.TabPage3.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new Form1());
        }


        private void RunQuery() {
            try {
                // Run query based on current parameter settings
                da.Fill(ds, "Titles");
                DataGrid1.DataSource = ds.Tables[0];
                ShowTable(ds.Tables[0].Select());
                FillSortCriteria();
            }
            catch (Exception ex) {
                Debug.WriteLine(ex.ToString());
                Console.WriteLine(ex.ToString());
            }
        }
        private void ShowTable(DataRow[] RowArray ) {
            try {
                string strS=null;

                for (int i =0 ; i<= RowArray.GetUpperBound(0);i++) {
                    for ( int intCol = 0; intCol <= RowArray[i].ItemArray.GetUpperBound(0); intCol++) {
                        strS = strS + RowArray[i][intCol].ToString() + "\t";
                    }
                    strS = strS + "\r\n";
                    txtShowRows.Text = strS;
                }
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }

        private void FillSortCriteria() {
            try {
                if (cmbSortArg.Items.Count > 0) {
                    return; 
                }

                foreach (DataColumn dc in ds.Tables[0].Columns) {
                    cmbSortArg.Items.Add(dc.Caption);
                }
            }
            catch (Exception ex) {             
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void btnQuery_Click(object sender, System.EventArgs e) {
            try{
                ds.Clear();
                cmd.Parameters[0].Value = txtQTitle.Text;
                cmd.Parameters[1].Value = txtQYearLow.Text;
                cmd.Parameters["@YearHigh"].Value = txtQYearHigh.Text;
                txtFilter.Text = cmd.Parameters[0].Value.ToString();

                RunQuery();
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        private void btnFilter_Click(object sender, System.EventArgs e) {

            try {
                DataRow[] FilteredRowArray;
                txtShowRows.Text = "";
                FilteredRowArray = ds.Tables[0].Select("Title LIKE '" + txtFilter.Text + "'");
                Debug.WriteLine(FilteredRowArray.GetUpperBound(0));
                if( FilteredRowArray.GetUpperBound(0) >= 0) {
                    ShowTable(FilteredRowArray);
                }
                else {
                    MessageBox.Show("No titles meet criteria (filtering).");
                }
            }
            catch ( Exception ex) {
                MessageBox.Show(ex.ToString());
            }
        }

        private void btnGeneralFilter_Click(object sender, System.EventArgs e) {
            try {
                DataRow[] FilteredRowArray;
                txtShowRows.Text = "";

                FilteredRowArray = ds.Tables[0].Select(txtGeneralFilter.Text);
                Debug.WriteLine(FilteredRowArray.GetUpperBound(0));
                if (FilteredRowArray.GetUpperBound(0) >= 0) {
                    ShowTable(FilteredRowArray);
                }
                else {
                    MessageBox.Show("No titles meet criteria (general filter).");
                }
            }
            catch ( Exception ex) {
                MessageBox.Show(ex.ToString());
            }
        }

        private void btnSort_Click(object sender, System.EventArgs e) {
            try {
                DataRow[] SortedRowArray;
                string strSortType;
                string strSort;
                string strFilter;

                if (rbAsc.Checked) {

                    strSort = cmbSortArg.Text + " ASC";
                }
                else {
                    strSort = cmbSortArg.Text + " DESC";
                }
                if (txtFilter.Text == "") {
                    strFilter = "";
                }
                else {
                    strFilter = "Title LIKE'" + txtFilter.Text + "'";
                }
                txtShowRows.Text = "";
                SortedRowArray = ds.Tables[0].Select(strFilter, strSort);
                Debug.WriteLine(SortedRowArray.GetUpperBound(0));
                if( SortedRowArray.GetUpperBound(0) >= 0 ) {
                    ShowTable(SortedRowArray);
                }
                else {
                    MessageBox.Show("No titles meet criteria (sorting).");
                }
            }
            catch (Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }
    }
}